/******************** (C) COPYRIGHT 2008 STMicroelectronics ********************
* File Name          : hw_config.h
* Author             : MCD Application Team
* Version            : V2.2.0
* Date               : 06/13/2008
* Description        : Hardware Configuration & Setup
********************************************************************************
* THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __HW_CONFIG_H
#define __HW_CONFIG_H

/* Includes ------------------------------------------------------------------*/
/* Exported types ------------------------------------------------------------*/
/* Codec Control defines */
#define PLLon             1
#define PLLoff            0

#define VerifData         1
#define NoVerifData       0 

#define Codec_PDN_GPIO	  GPIOG
#define Codec_PDN_Pin	  GPIO_Pin_11

#define BufferSize        100
#define CodecAddress      0x27

/* Exported constants --------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/
/* Exported define -----------------------------------------------------------*/
/* Exported functions ------------------------------------------------------- */
/* External variables --------------------------------------------------------*/
void Set_System(void);
void Set_USBClock(void);
void Enter_LowPowerMode(void);
void Leave_LowPowerMode(void);
void USB_Config(void);
void Audio_Config(void);
void USB_Cable_Config (FunctionalState NewState);
void Speaker_Config(void);

void NVIC_Config(void);
void GPIO_Config(void);
u32 Sound_release(u16 Standard, u16 MCLKOutput, u16 AudioFreq, u8 AudioRepetitions);
void I2S_Config(u16 Standard, u16 MCLKOutput, u16 AudioFreq);
void Codec_PowerDown(void);
u32 I2SCodec_WriteRegister(u32 RegisterAddr, u32 RegisterValue, u32 Verify);
u32 Codec_SpeakerConfig(u16 I2S_Standard, u8 volume, u32 verif, u8 pll);
static void Delay(vu32 nCount);
void Get_SerialNum(void);

#endif  /*__HW_CONFIG_H*/

/******************* (C) COPYRIGHT 2008 STMicroelectronics *****END OF FILE****/
